<?php
if (!($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']) AND $vbulletin->options['dbtech_vbsecurity_active'])
{
	// Preemptively require global
	require(DIR . '/dbtech/vbsecurity/hooks/global_start.php');

	VBSECURITY::$db->insert('dbtech_vbsecurity_adminstrikes', array(
		'username' 	=> htmlspecialchars_uni($vbulletin->userinfo['username']),
		'userid' 	=> $vbulletin->userinfo['userid'],
		'ipaddress' => IPADDRESS,
		'dateline' 	=> TIMENOW
	));

	if ($vbulletin->userinfo['userid'])
	{
		// Update this array
		$differences = '<li>' . construct_phrase($vbphrase['dbtech_vbsecurity_failedlogonadmin_user'],
			vbdate($vbulletin->options['logdateformat'], TIMENOW),
			$vbulletin->userinfo['username'],
			$vbulletin->userinfo['userid'],
			$vbulletin->userinfo['username'],
			IPADDRESS
		) . '</li>';
	}
	else
	{
		// Update this array
		$differences = '<li>' . construct_phrase($vbphrase['dbtech_vbsecurity_failedlogonadmin_guest'],
			vbdate($vbulletin->options['logdateformat'], TIMENOW),
			'N/A',
			IPADDRESS
		) . '</li>';

	}

	$added = false;
	foreach ((array)VBSECURITY::$cache['actions']['failedlogonadmin'] as $ruleid => $rules)
	{
		if (!$rules['intrusions'])
		{
			// We're not doin nothing
			continue;
		}

		if ($rules['ipaddresses'])
		{
			// Same IP
			$attempts = VBSECURITY::$db->fetchOne('SELECT COUNT(*) FROM $dbtech_vbsecurity_adminstrikes WHERE ipaddress = ? AND dateline >= ?', array(
				IPADDRESS,
				(TIMENOW - ($rules['hours'] * 3600)),
			));
		}
		else
		{
			// Any IP
			$attempts = VBSECURITY::$db->fetchOne('SELECT COUNT(*) FROM $dbtech_vbsecurity_adminstrikes WHERE dateline >= ?', array(
				(TIMENOW - ($rules['hours'] * 3600)),
			));
		}

		if ($attempts % $rules['intrusions'] == 0)
		{
			// Perform actions
			if ((int)$rules['actions'] & 1)
			{
				// Close forum
				require_once(DIR . '/includes/adminfunctions.php');
				require_once(DIR . '/includes/adminfunctions_options.php');
				save_settings(array(
					'bbactive' => 0,
					'bbclosedreason' => $vbulletin->options['dbtech_vbsecurity_breach_closedreason']
				));
			}

			if ((int)$rules['actions'] & 2)
			{
				// Email webmaster
				vbmail($vbulletin->options['webmasteremail'], construct_phrase($vbphrase['dbtech_vbmail_security_alert_title'],
					$vbphrase['dbtech_vbsecurity_watcher_failedlogonadmin']
				), construct_phrase($vbphrase['dbtech_vbmail_security_alert_body'],
					$vbphrase['dbtech_vbsecurity_watcher_failedlogonadmin'],
					strip_tags($differences),
					$vbulletin->options['bburl'],
					$vbulletin->config['Misc']['admincpdir'],
					'general'
				), true);
			}

			if ((int)$rules['actions'] & 8)
			{
				$addresses = preg_split('#\s+#', $vbulletin->options['banip'], -1, PREG_SPLIT_NO_EMPTY);
				if (!in_array(IPADDRESS, $addresses))
				{
					// Ban IP Address
					require_once(DIR . '/includes/adminfunctions.php');
					require_once(DIR . '/includes/adminfunctions_options.php');
					save_settings(array(
						'banip' => $vbulletin->options['banip'] . "\n" . IPADDRESS
					));
				}
			}

			if ($added)
			{
				// We've already updated the array
				continue;
			}

			if ($vbulletin->userinfo['userid'])
			{
				// Update this array
				VBSECURITY::$cache['watchers']['failedlogonadmin'] .= $differences;
			}
			else
			{
				// Update this array
				VBSECURITY::$cache['watchers']['failedlogonadmin'] .= $differences;

			}

			// Store data in the datastore (xD)
			build_datastore('dbtech_vbsecurity_watchers', trim(serialize(VBSECURITY::$cache['watchers'])), 1);

			// We've added to the array now
			$added = true;
		}
	}
}
?>